<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Artisan;

Route::get('/', 'FrontEndController@index')->name('fe');
Route::get('/struktur-organisasi', 'FrontEndController@struktur')->name('fe.struktur');
Route::get('/pages/{slug}', 'FrontEndController@visit')->name('fe.visit');
Route::get('/kontak', 'FrontEndController@kontak')->name('fe.kontak');
Route::get('/bukutamu', 'FrontEndController@bukutamu')->name('fe.bukutamu');
Route::get('/bukutamu/json', 'FrontEndController@bukutamuJson')->name('fe.bukutamu.json');
Route::post('/bukutamu/store', 'FrontEndController@bukutamuStore')->name('fe.bukutamu.store')->middleware('XssSanitizer');
Route::get('/blog', 'FrontEndController@blog')->name('fe.blog');
Route::get('/blog/{slug}', 'FrontEndController@blog')->name('fe.blog_detail');
Route::get('/blog-search', 'FrontEndController@blog_search')->name('fe.blog_search');
Route::get('/gallery', 'FrontEndController@gallery')->name('fe.gallery');
Route::get('/download', 'FrontEndController@download')->name('fe.download');
Route::post('/sendMail', 'FrontEndController@sendMail')->name('sendMail')->middleware('XssSanitizer');

/*Data Siswa */
Route::get('/data-siswa', 'FrontEndController@data_siswa')->name('fe.data_siswa');

/*Data Guru */
Route::get('/data-guru', 'FrontEndController@data_guru')->name('fe.data_guru');

Route::get('/install', 'InstallController@index')->name('install');
Route::post('/extract', 'InstallController@extract')->name('extract');
Route::get('/remove-installer', 'InstallController@removeInstaller')->name('removeInstaller');

Auth::routes(['register' => false]);
Route::prefix('admin')->group(function() {
	Route::get('/', 'HomeController@index')->name('home');
	Route::get('/home', 'HomeController@index')->name('home');
	Route::get('/profile-sekolah', 'ProfileSekolahController@index')->name('profile');
	Route::post('profile/update/logo', 'ProfileSekolahController@update_logo')->name('profile.update_logo');
	Route::post('profile/update/main-color', 'ProfileSekolahController@update_main_color')->name('profile.update_main_color');
	Route::post('/profile/update/nama_sekolah', 'ProfileSekolahController@update_nama_sekolah')->name('profile.update_nama_sekolah')->middleware('XssSanitizer');
	Route::post('/profile/update/deskripsi_sekolah', 'ProfileSekolahController@update_deskripsi_sekolah')->name('profile.update_deskripsi_sekolah')->middleware('XssSanitizer');
	Route::post('/profile/update/facebook', 'ProfileSekolahController@update_facebook')->name('profile.update_facebook')->middleware('XssSanitizer');
	Route::post('/profile/update/twitter', 'ProfileSekolahController@update_twitter')->name('profile.update_twitter')->middleware('XssSanitizer');
	Route::post('/profile/update/instagram', 'ProfileSekolahController@update_instagram')->name('profile.update_instagram')->middleware('XssSanitizer');
	Route::post('/profile/update/nama_tautan_1', 'ProfileSekolahController@update_nama_tautan_1')->name('profile.update_nama_tautan_1')->middleware('XssSanitizer');
	Route::post('/profile/update/nama_tautan_2', 'ProfileSekolahController@update_nama_tautan_2')->name('profile.update_nama_tautan_2')->middleware('XssSanitizer');
	Route::post('/profile/update/nama_tautan_3', 'ProfileSekolahController@update_nama_tautan_3')->name('profile.update_nama_tautan_3')->middleware('XssSanitizer');
	Route::post('/profile/update/tautan_1', 'ProfileSekolahController@update_tautan_1')->name('profile.update_tautan_1')->middleware('XssSanitizer');
	Route::post('/profile/update/tautan_2', 'ProfileSekolahController@update_tautan_2')->name('profile.update_tautan_2')->middleware('XssSanitizer');
	Route::post('/profile/update/tautan_3', 'ProfileSekolahController@update_tautan_3')->name('profile.update_tautan_3')->middleware('XssSanitizer');
	Route::post('/profile/update/telepon_sekolah', 'ProfileSekolahController@update_telepon_sekolah')->name('profile.update_telepon_sekolah')->middleware('XssSanitizer');
	Route::post('/profile/update/email_sekolah', 'ProfileSekolahController@update_email_sekolah')->name('profile.update_email_sekolah')->middleware('XssSanitizer');
	Route::post('/profile/update/alamat_sekolah', 'ProfileSekolahController@update_alamat_sekolah')->name('profile.update_alamat_sekolah')->middleware('XssSanitizer');

	/*Menu Navigasi*/
	Route::get('/menu-navigasi', 'MenuNavigasiController@index')->name('menu-navigasi');
	Route::get('/menu/json', 'MenuNavigasiController@json')->name('menu.json');
	Route::get('/menu/create', 'MenuNavigasiController@create')->name('menu.create');
	Route::post('/menu/store', 'MenuNavigasiController@store')->name('menu.store')->middleware('XssSanitizer');
	Route::get('/menu/{id}/edit', 'MenuNavigasiController@edit')->name('menu.edit');
	Route::put('/menu/update/{id}', 'MenuNavigasiController@update')->name('menu.update')->middleware('XssSanitizer');
	Route::post('/menu/remove', 'MenuNavigasiController@destroy')->name('menu.remove');

	/* Pages */
	Route::get('/pages', 'PagesController@index')->name('pages.index');
	Route::get('/pages/json', 'PagesController@json')->name('pages.json');
	Route::get('/pages/{id}/show', 'PagesController@show')->name('pages.show');
	Route::get('/pages/create', 'PagesController@create')->name('pages.create');
	Route::post('/pages/store', 'PagesController@store')->name('pages.store')->middleware('XssSanitizer');
	Route::get('/pages/{id}/edit', 'PagesController@edit')->name('pages.edit');
	Route::put('/pages/update/{id}', 'PagesController@update')->name('pages.update')->middleware('XssSanitizer');
	Route::post('/pages/update-status', 'PagesController@update_status')->name('pages.update_status');
	Route::post('/pages/update_foto', 'PagesController@update_picture')->name('pages.update_foto');
	Route::post('/pages/hapusGambar', 'PagesController@hapus_picture')->name('pages.hapusGambar');
	Route::post('/pages/remove', 'PagesController@destroy')->name('pages.remove');

	/* Banner */
	Route::get('/banner', 'BannerController@index')->name('banner.index');
	Route::get('/banner/json', 'BannerController@json')->name('banner.json');
	Route::get('/banner/create', 'BannerController@create')->name('banner.create');
	Route::post('/banner/store', 'BannerController@store')->name('banner.store')->middleware('XssSanitizer');
	Route::get('/banner/{id}/edit', 'BannerController@edit')->name('banner.edit');
	Route::put('/banner/update/{id}', 'BannerController@update')->name('banner.update')->middleware('XssSanitizer');
	Route::post('/banner/update_gambar', 'BannerController@update_gambar')->name('banner.update_gambar');
	Route::post('/banner/hapusGambar', 'BannerController@hapus_gambar')->name('banner.hapusGambar');
	Route::post('/banner/update-status', 'BannerController@update_status')->name('banner.update_status');
	Route::post('/banner/remove', 'BannerController@remove')->name('banner.remove');

	/* Management Sekolah */
	Route::get('/sekolah', 'ManagementSekolahController@index')->name('sekolah.index');
	Route::get('/sekolah/json', 'ManagementSekolahController@json')->name('sekolah.json');
	Route::get('/sekolah/create', 'ManagementSekolahController@create')->name('sekolah.create');
	Route::post('/sekolah/store', 'ManagementSekolahController@store')->name('sekolah.store')->middleware('XssSanitizer');
	Route::get('/sekolah/{id}/edit', 'ManagementSekolahController@edit')->name('sekolah.edit');
	Route::put('/sekolah/update/{id}', 'ManagementSekolahController@update')->name('sekolah.update')->middleware('XssSanitizer');
	Route::post('/sekolah/update_foto', 'ManagementSekolahController@update_foto')->name('sekolah.update_foto');
	Route::post('/sekolah/hapusGambar', 'ManagementSekolahController@hapus_foto')->name('sekolah.hapusGambar');
	Route::post('/sekolah/update-status', 'ManagementSekolahController@update_status')->name('sekolah.update_status');
	Route::post('/sekolah/remove', 'ManagementSekolahController@remove')->name('sekolah.remove');

	/* Running Text */
	Route::get('/running', 'RunningTextController@index')->name('running.index');
	Route::get('/running/json', 'RunningTextController@json')->name('running.json');
	Route::get('/running/create', 'RunningTextController@create')->name('running.create');
	Route::post('/running/store', 'RunningTextController@store')->name('running.store')->middleware('XssSanitizer');
	Route::get('/running/{id}/edit', 'RunningTextController@edit')->name('running.edit');
	Route::put('/running/update/{id}', 'RunningTextController@update')->name('running.update')->middleware('XssSanitizer');
	Route::post('/running/update-status', 'RunningTextController@update_status')->name('running.update_status');
	Route::post('/running/remove', 'RunningTextController@remove')->name('running.remove');

	/* Kegiatan */
	Route::get('/kegiatan', 'KegiatanController@index')->name('kegiatan.index');
	Route::get('/kegiatan/json', 'KegiatanController@json')->name('kegiatan.json');
	Route::get('/kegiatan/create', 'KegiatanController@create')->name('kegiatan.create');
	Route::post('/kegiatan/store', 'KegiatanController@store')->name('kegiatan.store')->middleware('XssSanitizer');
	Route::get('/kegiatan/{id}/edit', 'KegiatanController@edit')->name('kegiatan.edit');
	Route::put('/kegiatan/update/{id}', 'KegiatanController@update')->name('kegiatan.update')->middleware('XssSanitizer');
	Route::post('/kegiatan/update-status', 'KegiatanController@update_status')->name('kegiatan.update_status');
	Route::post('/kegiatan/update_picture', 'KegiatanController@update_picture')->name('kegiatan.update_picture');
	Route::post('/kegiatan/hapusGambar', 'KegiatanController@hapus_picture')->name('kegiatan.hapusGambar');
	Route::post('/kegiatan/remove', 'KegiatanController@remove')->name('kegiatan.remove');

	/* Blog */
	Route::get('/blog', 'BlogController@index')->name('blog.index');
	Route::get('/blog/json', 'BlogController@json')->name('blog.json');
	Route::get('/blog/create', 'BlogController@create')->name('blog.create');
	Route::post('/blog/store', 'BlogController@store')->name('blog.store')->middleware('XssSanitizer');
	Route::get('/blog/{id}/edit', 'BlogController@edit')->name('blog.edit');
	Route::put('/blog/update/{id}', 'BlogController@update')->name('blog.update')->middleware('XssSanitizer');
	Route::post('/blog/update-status', 'BlogController@update_status')->name('blog.update_status');
	Route::post('/blog/update_picture', 'BlogController@update_picture')->name('blog.update_picture');
	Route::post('/blog/hapusGambar', 'BlogController@hapus_picture')->name('blog.hapusGambar');
	Route::post('/blog/remove', 'BlogController@remove')->name('blog.remove');
	Route::get('/blog/export-pdf/{slug}', 'BlogController@downloadPDF')->name('blog.downloadPDF');

	/* Links */
	Route::get('/link', 'LinkController@index')->name('link.index');
	Route::get('/link/json', 'LinkController@json')->name('link.json');
	Route::get('/link/create', 'LinkController@create')->name('link.create');
	Route::post('/link/store', 'LinkController@store')->name('link.store')->middleware('XssSanitizer');
	Route::get('/link/{id}/edit', 'LinkController@edit')->name('link.edit');
	Route::put('/link/update/{id}', 'LinkController@update')->name('link.update')->middleware('XssSanitizer');
	Route::post('link/update-status', 'LinkController@update_status')->name('link.update_status');
	Route::post('/link/remove', 'LinkController@remove')->name('link.remove');

	/* Gallery */
	Route::get('/gallery', 'GalleryController@index')->name('gallery.index');
	Route::get('/gallery/json', 'GalleryController@json')->name('gallery.json');
	Route::get('/gallery/create', 'GalleryController@create')->name('gallery.create');
	Route::post('/gallery/store', 'GalleryController@store')->name('gallery.store')->middleware('XssSanitizer');
	Route::get('/gallery/{id}/edit', 'GalleryController@edit')->name('gallery.edit');
	Route::post('gallery/update-status', 'GalleryController@update_status')->name('gallery.update_status');
	Route::post('/gallery/update_foto', 'GalleryController@update_foto')->name('gallery.update_foto');
	Route::post('/gallery/hapusGambar', 'GalleryController@hapus_foto')->name('gallery.hapusGambar');
	Route::post('/gallery/remove', 'GalleryController@remove')->name('gallery.remove');

	/* File */
	Route::get('/file', 'FileController@index')->name('file.index');
	Route::get('/file/json', 'FileController@json')->name('file.json');
	Route::get('/file/create', 'FileController@create')->name('file.create');
	Route::post('/file/store', 'FileController@store')->name('file.store')->middleware('XssSanitizer');
	Route::get('/file/{id}/edit', 'FileController@edit')->name('file.edit');
	Route::post('/file/update-status', 'FileController@update_status')->name('file.update_status');
	Route::post('/file/update_file', 'FileController@update_file')->name('file.update_file');
	Route::post('/file/remove', 'FileController@remove')->name('file.remove');

    /* Profile User */
    Route::get('/profile', 'ProfileController@index')->name('profile.index');
    Route::get('/profile/{id}/edit', 'ProfileController@edit')->name('profile.edit');
    Route::put('/profile/update/{id}', 'ProfileController@update')->name('profile.update')->middleware('XssSanitizer');
    Route::get('/profile/reset-token/{id}', 'ProfileController@resetToken')->name('profile.resetToken');
	Route::post('/profile/update_foto', 'ProfileController@update_foto')->name('profile.update_foto');

	/* Struktur Organisasi */
	Route::get('/struktur', 'StrukturOrganisasiController@index')->name('struktur.index');
	Route::get('/struktur/json', 'StrukturOrganisasiController@json')->name('struktur.json');
	Route::get('/struktur/{id}/edit', 'StrukturOrganisasiController@edit')->name('struktur.edit');
	Route::post('struktur/update-status', 'StrukturOrganisasiController@update_status')->name('struktur.update_status');
	Route::post('/struktur/update_struktur', 'StrukturOrganisasiController@update_struktur')->name('struktur.update_foto');
	Route::post('/struktur/hapusGambar', 'StrukturOrganisasiController@hapus_struktur')->name('struktur.hapusGambar');
	Route::post('/struktur/remove', 'StrukturOrganisasiController@remove')->name('struktur.remove');

    //Buku Tamu
    Route::get('bukutamu', 'BukuTamuController@index')->name('bukutamu.index');
    Route::get('bukutamu/json', 'BukuTamuController@json')->name('bukutamu.json');
    Route::get('bukutamu/{id}/show', 'BukuTamuController@show')->name('bukutamu.show');
    Route::delete('bukutamu/remove/{id}', 'BukuTamuController@destroy')->name('bukutamu.destroy');

    //User Management
    Route::get('users', 'UserManagementController@index')->name('users.index');
    Route::get('users/json', 'UserManagementController@json')->name('users.json');
    Route::get('users/create', 'UserManagementController@create')->name('users.create');
    Route::post('users/store', 'UserManagementController@store')->name('users.store')->middleware('XssSanitizer');
    Route::get('users/{id}/edit', 'UserManagementController@edit')->name('users.edit');
    Route::put('users/update/{id}', 'UserManagementController@update')->name('users.update')->middleware('XssSanitizer');
    Route::delete('users/remove/{id}', 'UserManagementController@destroy')->name('users.destroy');

    //Web Service
    Route::get('api/libraries', 'ApiLibrariesController@index')->name('apilibs.index');

    /* Update Web */
    Route::get('system/update', 'UpdateController@formUpdate')->name('system.update');
    Route::get('system/process-update', 'UpdateController@doUpdate')->name('system.doUpdate');

    //Logging
    Route::get('logging', 'LoggingController@index')->name('logging.index');
    Route::get('logging/json', 'LoggingController@json')->name('logging.json');

    //Optimize
    Route::get('artisan/optimize', 'UpdateController@doOptimize')->name('artisan.optimize');

    //Backup
    Route::get('backup', 'BackUpController@index')->name('backup');
});
