@extends('layouts.master')
@section('title', 'Kontak')
@section('content')

<!-- Breadcrumb section -->
<div class="site-breadcrumb">
	<div class="container">
		<a href="#"><i class="fa fa-home"></i> Home</a> <i class="fa fa-angle-right"></i>
		<span>Kontak</span>
	</div>
</div>
<!-- Breadcrumb section end -->


<!-- Courses section -->
<section class="contact-page spad pt-0">
	<div class="container">
		<div class="map-section">
			<div class="contact-info-warp">
				<div class="contact-info">
					<h4>Address</h4>
					<p>{{Helper::kontak_config('alamat_jalan', Helper::web_config('sekolah_id'))}}, RT.{{Helper::kontak_config('rt', Helper::web_config('sekolah_id'))}}/RW.{{Helper::kontak_config('rw', Helper::web_config('sekolah_id'))}}. {{Helper::kontak_config('nama_dusun', Helper::web_config('sekolah_id'))}}, {{Helper::kontak_config('desa_kelurahan', Helper::web_config('sekolah_id'))}}</p>
				</div>
				<div class="contact-info">
					<h4>Phone</h4>
					<p>{{Helper::kontak_config('nomor_telepon', Helper::web_config('sekolah_id'))}}</p>
				</div>
				<div class="contact-info">
					<h4>Email</h4>
					<p><a href="mailto:{{Helper::kontak_config('email', Helper::web_config('sekolah_id'))}}" target="_blank" class="text-white">{{Helper::kontak_config('email', Helper::web_config('sekolah_id'))}}</a></p>
				</div>
				<div class="contact-info">
					<h4>Working time</h4>
					<p>Monday - Friday: 07:00 - 14:00 WIB</p>
				</div>
			</div>
			<!-- Google map -->
			<div class="map" id="map"></div>
		</div>
		<!-- <div class="contact-form spad pb-0">
			<div class="section-title text-center">
				<h3>GET IN TOUCH</h3>
				<p>Contact us for best deals and offer</p>
			</div>
			<form class="comment-form --contact" method="post" action="{{url('/sendMail')}}">
				{{ csrf_field() }}
				<div class="row">
					<div class="col-lg-4">
						<input type="text" name="name" placeholder="Your Name">
					</div>
					<div class="col-lg-4">
						<input type="text" name="email" placeholder="Your Email">
					</div>
					<div class="col-lg-4">
						<input type="text" name="subject" placeholder="Subject">
					</div>
					<div class="col-lg-12">
						<textarea name="message" placeholder="Message"></textarea>
						<div class="text-center">
							<button class="site-btn">SUBMIT</button>
						</div>
					</div>
				</div>
			</form>
		</div> -->
	</div>
</section>
<!-- Courses section end-->

@endsection

@push('scripts')
<!-- load for map -->
<!-- <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB0YyDTa0qqOjIerob2VTIwo_XVMhrruxo"></script>
<script src="{{ url('assets/frontend/js/map.js') }}"></script> -->
<script>
  function initMap() {
    var id = "{{ $data->sekolah_id }}";
    var name = "{{ $data->nama }}";
    var address = "{{ $data->alamat_jalan }}";
    var myLatLng = {lat: <?php echo $data->lintang; ?>, lng: <?php echo $data->bujur; ?>};
    var infoWindow = new google.maps.InfoWindow;

    var map = new google.maps.Map(document.getElementById('map'), {
      center: myLatLng,
      zoom: 17
    });

    var infowincontent = document.createElement('div');
    var strong = document.createElement('strong');
    strong.textContent = name;
    infowincontent.appendChild(strong);
    infowincontent.appendChild(document.createElement('br'));

    var text = document.createElement('text');
    text.textContent = address;
    infowincontent.appendChild(text);

    var marker = new google.maps.Marker({
      position: myLatLng,
      map: map
    });

    marker.addListener('click', function() {
      infoWindow.setContent(infowincontent);
      infoWindow.open(map, marker);
    });
  }
</script>
<script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDh4_-eXYLzxs1EglZYdD-jGPB69MLusw4&callback=initMap"></script>
@endpush