@extends('layouts.master')
@section('title', 'Download File')
@section('content')

<!-- Breadcrumb section -->
<div class="site-breadcrumb">
	<div class="container">
		<a href="#"><i class="fa fa-home"></i> Home</a> <i class="fa fa-angle-right"></i>
		<span>Download File</span>
	</div>
</div>
<!-- Breadcrumb section end -->


<!-- About section -->
<section class="about-section spad pt-0">
	<div class="container">
		<div class="section-title text-center">
			<h3>File Data</h3>
			<p>List file-file yang dapat anda unduh</p>
		</div>
		<div class="row">
			<div class="col-lg-12" style="font-size: 14px;">
				<table class="table table-striped table-bordered table-hover">
					<thead>
						<tr>
							<th>#</th>
							<th>File Name</th>
						</tr>
					</thead>
					<tbody>
						@foreach($data as $row)
						<tr>
							<td><a class="btn btn-lg btn-info" href="{{ url('assets/files/file') }}/{{ $row->file }}" target="_blank"><i class="fa fa-download"></i></a></td>
							<td>{{ $row->name }}</td>
						</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>
</section>
<!-- About section end-->

@endsection

@push('style')
<!-- DataTables -->
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/rowReorder.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/responsive.dataTables.min.css">
@endpush

@push('scripts')
<!-- DataTables -->
<script src="{{url('assets/backend/DataTables')}}/js/jquery.dataTables.min.js"></script>
<script src="{{url('assets/backend/DataTables')}}/js/dataTables.rowReorder.min.js"></script>
<script src="{{url('assets/backend/DataTables')}}/js/dataTables.responsive.min.js"></script>
<script type="text/javascript">
	$('#datatables').DataTable({
      "stateSave": true,
      "searching" : true,
    });
</script>
@endpush