@extends('layouts.app')
@section('title', 'Profile Sekolah')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
    Profile
    <small>Setting Profile Sekolah</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Profile</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
	<!-- Info boxes -->
	<div class="row">
		@foreach($data as $row)
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-info-circle"></i> Informasi</h3>
					<input type="hidden" name="id_sekolah" id="id_sekolah" value="{{ $row->id }}">
				</div>
				<div class="box-body">
					<table class="table table-striped table-bordered table-hover">
						<tbody>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_nama_sekolah">{{$row->nama_sekolah}}</span>
									<input type="text" class="form-control" name="nama_sekolah" id="nama_sekolah" value="{{$row->nama_sekolah}}" placeholder="Nama Sekolah" style="display: none;">
								</td>
							</tr>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_deskripsi_sekolah">{{$row->deskripsi_sekolah}}</span>
									<input type="text" class="form-control" name="deskripsi_sekolah" id="deskripsi_sekolah" value="{{$row->deskripsi_sekolah}}" placeholder="Deskripsi Sekolah" maxlength="160" style="display: none;">
								</td>
							</tr>
							<tr>
								<td id="logo">
									<a href="#" onclick="document.getElementById('logo-{{$row->id}}').click()" title="Klik untuk ganti logo"><img src="@if($row->logo != NULL ){{ url('assets/files/logo/thumbnail/'.$row->logo.'?time='.time()) }}@else{{ url('assets/frontend/img/no-picture.png?time='.time()) }}@endif" width="10%"></a>
									<form method="post" action="" enctype="multipart/form-data">
									  <input type="hidden" name="_token" id="_token" value="{{csrf_token()}}">
									  <input type="hidden" name="id" value="{{ $row->id }}">
									  <input style="display: none;" type="file" name="logo" id="logo-{{$row->id}}" data-id="{{$row->id}}" class="uploadfoto" accept="image/*">
									</form>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-info-circle"></i> Warna Utama Website</h3>
				</div>
				<div class="box-body">
                    <table class="table table-striped table-bordered table-hover">
                        <tbody>
                            <tr>
                                <th>Pilih Warna</th>
                                <td><input type="color" name="main_color" id="main_color" value="{{ $row->main_color }}"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
			</div>
		</div>
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-bookmark"></i> Media Sosial</h3>
				</div>
				<div class="box-body">
					<table class="table table-striped table-bordered table-hover">
						<tbody>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_facebook">{{$row->facebook}}</span>
									<input type="text" class="form-control" name="facebook" id="facebook" value="{{$row->facebook}}" placeholder="Official Facebook" style="display: none;">
								</td>
							</tr>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_twitter">{{$row->twitter}}</span>
									<input type="text" class="form-control" name="twitter" id="twitter" value="{{$row->twitter}}" placeholder="Official Twitter" style="display: none;">
								</td>
							</tr>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_instagram">{{$row->instagram}}</span>
									<input type="text" class="form-control" name="instagram" id="instagram" value="{{$row->instagram}}" placeholder="Official Instagram" style="display: none;">
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-link"></i> Tautan</h3>
				</div>
				<div class="box-body">
					<table class="table table-striped table-bordered table-hover">
						<thead>
							<tr>
								<th>Nama Tautan</th>
								<th>Alamat Tautan</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_nama_tautan_1">{{$row->nama_tautan_1}}</span>
									<input type="text" class="form-control" name="nama_tautan_1" id="nama_tautan_1" value="{{$row->nama_tautan_1}}" placeholder="Nama Tautan 1" style="display: none;">
								</td>
								<td title="Klik untuk edit">
									<span id="def_tautan_1">{{$row->tautan_1}}</span>
									<input type="text" class="form-control" name="tautan_1" id="tautan_1" value="{{$row->tautan_1}}" placeholder="Tautan 1" style="display: none;">
								</td>
							</tr>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_nama_tautan_2">{{$row->nama_tautan_2}}</span>
									<input type="text" class="form-control" name="nama_tautan_2" id="nama_tautan_2" value="{{$row->nama_tautan_2}}" placeholder="Nama Tautan 2" style="display: none;">
								</td>
								<td title="Klik untuk edit">
									<span id="def_tautan_2">{{$row->tautan_2}}</span>
									<input type="text" class="form-control" name="tautan_2" id="tautan_2" value="{{$row->tautan_2}}" placeholder="Tautan 2" style="display: none;">
								</td>
							</tr>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_nama_tautan_3">{{$row->nama_tautan_3}}</span>
									<input type="text" class="form-control" name="nama_tautan_3" id="nama_tautan_3" value="{{$row->nama_tautan_3}}" placeholder="Nama Tautan 3" style="display: none;">
								</td>
								<td title="Klik untuk edit">
									<span id="def_tautan_3">{{$row->tautan_3}}</span>
									<input type="text" class="form-control" name="tautan_3" id="tautan_3" value="{{$row->tautan_3}}" placeholder="Tautan 3" style="display: none;">
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-phone"></i> Kontak</h3>
				</div>
				<div class="box-body">
					<div class="table-responsive">
						<table class="table table-bordered">
							<thead>
								<tr>
									<th>Telepon</th>
									<th>Website</th>
									<th>Email</th>
									<th>Alamat</th>
								</tr>
							</thead>
							<tbody>
								<tr>
                                    <td title="Klik untuk edit">
                                        <span id="def_nomor_telepon">{{ $row->telepon_sekolah ?? '-' }}</span>
                                        <input type="text" class="form-control" name="nomor_telepon" id="nomor_telepon" value="{{ $row->telepon_sekolah }}" placeholder="Nomor telepon" style="display: none;">
                                    </td>
                                    <td>
                                        <span>{{Helper::kontak_config('website', Helper::web_config('sekolah_id'))}}</span>

                                    </td>
                                    <td title="Klik untuk edit">
                                        <span id="def_email_sekolah">{{ $row->email_sekolah ?? '-' }}</span>
                                        <input type="text" class="form-control" name="email_sekolah" id="email_sekolah" value="{{ $row->email_sekolah }}" placeholder="Email Sekolah" style="display: none;">
                                    </td>
                                    <td>
                                        <span>{{Helper::kontak_config('alamat_jalan', Helper::web_config('sekolah_id'))}}, RT.{{Helper::kontak_config('rt', Helper::web_config('sekolah_id'))}}/RW.{{Helper::kontak_config('rw', Helper::web_config('sekolah_id'))}}. {{Helper::kontak_config('nama_dusun', Helper::web_config('sekolah_id'))}}, {{Helper::kontak_config('desa_kelurahan', Helper::web_config('sekolah_id'))}}</span>
                                    </td>
				                </tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	@endforeach
	</div>
</section>

@endsection

@push('scripts')
<script type="text/javascript">
$(document).ready(function(){
	$('#def_nama_sekolah').on('click', function(){
		document.getElementById("def_nama_sekolah").style.display="none";
		document.getElementById("nama_sekolah").style.display="block";
	});
	$('#def_deskripsi_sekolah').on('click', function(){
		document.getElementById("def_deskripsi_sekolah").style.display="none";
		document.getElementById("deskripsi_sekolah").style.display="block";
	});
	$('#def_facebook').on('click', function(){
		document.getElementById("def_facebook").style.display="none";
		document.getElementById("facebook").style.display="block";
	});
	$('#def_twitter').on('click', function(){
		document.getElementById("def_twitter").style.display="none";
		document.getElementById("twitter").style.display="block";
	});
	$('#def_instagram').on('click', function(){
		document.getElementById("def_instagram").style.display="none";
		document.getElementById("instagram").style.display="block";
	});
	$('#def_nama_tautan_1').on('click', function(){
		document.getElementById("def_nama_tautan_1").style.display="none";
		document.getElementById("nama_tautan_1").style.display="block";
	});
	$('#def_nama_tautan_2').on('click', function(){
		document.getElementById("def_nama_tautan_2").style.display="none";
		document.getElementById("nama_tautan_2").style.display="block";
	});
	$('#def_nama_tautan_3').on('click', function(){
		document.getElementById("def_nama_tautan_3").style.display="none";
		document.getElementById("nama_tautan_3").style.display="block";
	});
	$('#def_tautan_1').on('click', function(){
		document.getElementById("def_tautan_1").style.display="none";
		document.getElementById("tautan_1").style.display="block";
	});
	$('#def_tautan_2').on('click', function(){
		document.getElementById("def_tautan_2").style.display="none";
		document.getElementById("tautan_2").style.display="block";
	});
	$('#def_tautan_3').on('click', function(){
		document.getElementById("def_tautan_3").style.display="none";
		document.getElementById("tautan_3").style.display="block";
	});
	$('#def_nomor_telepon').on('click', function(){
		document.getElementById("def_nomor_telepon").style.display="none";
		document.getElementById("nomor_telepon").style.display="block";
	});
	$('#def_email_sekolah').on('click', function(){
		document.getElementById("def_email_sekolah").style.display="none";
		document.getElementById("email_sekolah").style.display="block";
	});

	/*Process Update*/
	$('#main_color').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_main_color') }}", // Isi dengan url/path file php yang dituju
			data: {
				_token: "{{csrf_token()}}",
				id: $('#id_sekolah').val(),
				main_color: $(this).val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#nama_sekolah').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_nama_sekolah') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			nama_sekolah: $('#nama_sekolah').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#deskripsi_sekolah').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_deskripsi_sekolah') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			deskripsi_sekolah: $('#deskripsi_sekolah').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('body').on('change', '.uploadfoto', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		var id = $(this).attr('data-id');
		var fileSelect = document.getElementById($(this).attr('id'));
		var token = $('#_token').val();
		var files = fileSelect.files[0];
		var formData = new FormData();
		formData.append('logo', files);
		formData.append('id', id);
		formData.append('_token', token);
		$.ajax({
            url: "{{route('profile.update_logo')}}",
            method: "POST",
            dataType: "JSON",
            data: formData,
            processData: false,
            contentType: false,
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    $('#modal').modal('hide');
                    $('#logo').load(location.href + " #logo");
                    swal({
                        type: 'success',
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        type: 'error',
                        icon: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr, status, error){
                timeout = setTimeout(loaded, 1000);
                $('#modal').modal('hide');
                $('#datatables').DataTable().ajax.reload();
                data = JSON.parse(xhr.responseText);
                $.each(data, function(key, item){
                    swal({
                    type: 'error',
                    icon: 'error',
                    title: 'Gagal!',
                    text: 'Gagal upload logo, '+item.logo+'!'
                    });
                });
            }
		});
	});

	$('#facebook').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_facebook') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			facebook: $('#facebook').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText
                });
			}
		})
	});

	$('#twitter').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_twitter') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			twitter: $('#twitter').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#instagram').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_instagram') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			instagram: $('#instagram').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#nama_tautan_1').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_nama_tautan_1') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			nama_tautan_1: $('#nama_tautan_1').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#nama_tautan_2').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_nama_tautan_2') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			nama_tautan_2: $('#nama_tautan_2').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#nama_tautan_3').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_nama_tautan_3') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			nama_tautan_3: $('#nama_tautan_3').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#tautan_1').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_tautan_1') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			tautan_1: $('#tautan_1').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#tautan_2').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_tautan_2') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			tautan_2: $('#tautan_2').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#tautan_3').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "{{ route('profile.update_tautan_3') }}", // Isi dengan url/path file php yang dituju
			data: {
			_token: "{{csrf_token()}}",
			id: $('#id_sekolah').val(),
			tautan_3: $('#tautan_3').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

    $('#nomor_telepon').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_telepon_sekolah') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                telepon_sekolah: $('#nomor_telepon').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#email_sekolah').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_email_sekolah') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                email_sekolah: $('#email_sekolah').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
            }
        })
    });

});
</script>
@endpush
