@extends('layouts.app')
@section('title', 'Logging Data')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
    Logging
    <small>Data log aktivitas web</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Logging</li>
  </ol>
</section>

<!-- Main content -->
<section class="content">
	<!-- Info boxes -->
	<div class="row">
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-list"></i> Logging</h3>
				</div>
				<div class="box-body">
                    <div class="table-responsive">
                        <table id="datatables" class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Username</th>
                                    <th>IP Address</th>
                                    <th>Detail Log</th>
                                    <th>Tanggal Dibuat</th>
                                    <th>Tanggal Update</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
				</div>
			</div>
		</div>
	</div>
</section>

@endsection

@push('scripts')
<script type="text/javascript">
$(document).ready(function(){
	var dataTable = $('#datatables').DataTable({
      "stateSave": true,
      "processing" : true,
      "serverSide" : true,
      "searching" : true,
      "language": {
          processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span> '
      },
      "ajax" : {
       "url": "{{ route('logging.json') }}",
       "dataType": "json",
       "type": "GET"
      },
      "columns": [
        { data: 'DT_RowIndex', name: 'DT_RowIndex' },
        { "data": "username" },
        { "data": "ip_address" },
        { "data": "log" },
        { "data": "created_at" },
        { "data": "updated_at" },
      ],
      "columnDefs": [
          { "targets": 0, "width": "10%", "orderable" : false },
      ],
    });
});
</script>
@endpush
