<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserItem extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=> $this->id,
            'username' => $this->username,
            'name' => $this->name,
            'email' => $this->email,
            'image' => $this->foto != NULL ? url('assets/files/profile/'.$this->foto.'?time='.time()) : NULL,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
