<?php

namespace App\Http\Controllers;

use App\MenuNavigasi;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Helper;
use Illuminate\Database\QueryException;
use Illuminate\Http\Response;
use Yajra\DataTables\Facades\DataTables;

class MenuNavigasiController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $data = MenuNavigasi::get();
        return view('pages.be.menu_navigasi', compact('data'));
    }

    function json()
    {
        set_time_limit(0);
        ini_set('memory_limit', '-1');
        $data = MenuNavigasi::orderBy('id', 'DESC')->get();
        return DataTables::of($data)
                    ->addIndexColumn()
                    ->editColumn('options', function($row){
                        if(in_array($row->id, [1,2,3,4,5,6,9,10,11,18,19])){
                            $edit = "#";
                            $disabled = "disabled";
                            $modal = "";
                        }else{
                            $edit = route('menu.edit', $row->id);
                            $disabled = "";
                            $modal = "modal-show edit";
                        }
                        $btn = "&emsp;<a href='{$edit}' class='btn btn-sm btn-warning $modal' title='Form Edit Menu: {$row->nama}' $disabled><i class='fa fa-pencil'></i></a> <button type='button' class='btn btn-sm btn-danger' id='destroy' data-id='{$row->id}' $disabled><i class='fa fa-trash'></i></button>";
                        return $btn;
                    })
                    ->editColumn('created_at', function($row){
                        return $row->created_at != NULL ? \Helper::tgl_indo($row->created_at) : "-";
                    })
                    ->editColumn('updated_at', function($row){
                        return $row->updated_at != NULL ? \Helper::tgl_indo($row->updated_at) : "-";
                    })
                    ->rawColumns(['options'])
                    ->toJson();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $model = new MenuNavigasi();
        $menu = MenuNavigasi::where('parent_id', 0)->get();
        return view('pages.be.form_menu', compact('model', 'menu'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $this->validate($request, [
                'nama' => 'required|string',
                'slug' => '',
                'parent_id' => 'required'
            ], [
                'nama.required' => 'Nama tidak boleh kosong!',
                'parent_id.required' => 'Parent Menu harus dipilih!'
            ]);

            $data = new MenuNavigasi();
            $data->nama = $request->nama;
            if ($request->slug != "") {
                $data->slug = $request->slug;
            } else {
                $data->slug = "#";
            }
            $data->parent_id = $request->parent_id;
            $data->created_at = Carbon::now('Asia/Jakarta');
            $data->updated_at = null;
            $data->save();
            \Helper::log(\Auth::user()->username, "Menambah menu baru : ".$data->name);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil menambahkan menu!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\MenuNavigasi  $menuNavigasi
     * @return \Illuminate\Http\Response
     */
    public function show(MenuNavigasi $menuNavigasi)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\MenuNavigasi  $menuNavigasi
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $model = MenuNavigasi::findOrFail($id);
        $menu = MenuNavigasi::get();
        return view('pages.be.form_menu', compact('model', 'menu'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\MenuNavigasi  $menuNavigasi
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'nama' => 'required|string',
                'slug' => '',
                'parent_id' => 'required'
            ]);

            $data = array(
                'nama' => $request->nama,
                'slug' => $request->slug,
                'parent_id' => $request->parent_id,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $nav = MenuNavigasi::findOrFail($id);
            $nav->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate menu : ".$nav->name);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengupdate menu!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\MenuNavigasi  $menuNavigasi
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        try {
            $id = $request->input('id');
            $nav = MenuNavigasi::findOrFail($id);
            $nav->delete();
            \Helper::log(\Auth::user()->username, "Menghapus menu : ".$nav->name);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil menghapus menu!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }

    }
}
