<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Banner;
use App\Blog;
use App\DataFile;
use App\Gallery;
use App\Kegiatan;
use App\ProfileSekolah;
use App\Pages;
use App\User;
use App\ManagementSekolah;
use App\StrukturOrganisasi;
use Exception;
use File;
use Illuminate\Http\Response;
use Throwable;
use ZipArchive;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Helper;

class BackUpController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    function __construct()
    {
        $this->middleware(['auth']);
    }

    public function index()
    {
        set_time_limit(0);
        ini_set('memory_limit', '5048M');
        $banners = Banner::get();
        $blogs = Blog::get();
        $files = DataFile::get();
        $gallerys = Gallery::get();
        $kegiatans = Kegiatan::get();
        $logos = ProfileSekolah::get();
        $pages = Pages::get();
        $profiles = User::get();
        $gurus = ManagementSekolah::get();
        $strukturs = StrukturOrganisasi::get();
        $fileArr = array();
        foreach($banners as $key => $val){
            $fileArr[] = $val->picture;
        }
        foreach($blogs as $key => $val){
            $fileArr[] = $val->picture;
        }
        foreach($files as $key => $val){
            $fileArr[] = $val->file;
        }
        foreach($gallerys as $key => $val){
            $fileArr[] = $val->picture;
        }
        foreach($kegiatans as $key => $val){
            $fileArr[] = $val->picture;
        }
        foreach($logos as $key => $val){
            $fileArr[] = $val->logo;
        }
        foreach($pages as $key => $val){
            $fileArr[] = $val->picture;
        }
        foreach($profiles as $key => $val){
            $fileArr[] = $val->foto;
        }
        foreach($gurus as $key => $val){
            $fileArr[] = $val->foto;
        }
        foreach($strukturs as $key => $val){
            $fileArr[] = $val->struktur;
        }
        $zipLink = $this->converToZip($fileArr);
        return $zipLink;
    }

    /**
     * Function to covert all DB files to Zip
     */
    public function converToZip($fileArr)
    {
        try {
            set_time_limit(0);
            ini_set('memory_limit', '-1');
            ini_set('max_execution_time', '0');
            $zip = new ZipArchive;
            if(!File::isDirectory('assets/backup')){
                File::makeDirectory('assets/backup', 0755, true, true);
            }
            $storage_path = 'assets/backup';
            $zipFileName = $storage_path.'/'.Helper::web_config('npsn').'.zip';
            if ($zip->open(($zipFileName), ZipArchive::CREATE) === true) {
                foreach ($fileArr as $relativName) {
                    if(!empty($relativName)){
                        $bannerName = "assets/files/banner/".$relativName;
                        $blogName = "assets/files/blog/".$relativName;
                        $fileName = "assets/files/file/".$relativName;
                        $galleryName = "assets/files/gallery/".$relativName;
                        $kegiatanName = "assets/files/kegiatan/".$relativName;
                        $logoName = "assets/files/logo/".$relativName;
                        $pageName = "assets/files/pages/".$relativName;
                        $profileName = "assets/files/profile/".$relativName;
                        $guruName = "assets/files/sekolah/".$relativName;
                        $strukturName = "assets/files/struktur/".$relativName;
                        $bannerNameThumb = "assets/files/banner/thumbnail/".$relativName;
                        $blogNameThumb = "assets/files/blog/thumbnail/".$relativName;
                        $galleryNameThumb = "assets/files/gallery/thumbnail/".$relativName;
                        $kegiatanNameThumb = "assets/files/kegiatan/thumbnail/".$relativName;
                        $logoNameThumb = "assets/files/logo/thumbnail/".$relativName;
                        $pageNameThumb = "assets/files/pages/thumbnail/".$relativName;
                        $profileNameThumb = "assets/files/profile/thumbnail/".$relativName;
                        $guruNameThumb = "assets/files/sekolah/thumbnail/".$relativName;
                        $strukturNameThumb = "assets/files/struktur/thumbnail/".$relativName;

                        if(file_exists($bannerName)){
                            $zip->addFile("assets/files/banner/".$relativName, $bannerName);
                        }
                        if(file_exists($bannerNameThumb)){
                            $zip->addFile("assets/files/banner/thumbnail/".$relativName, $bannerNameThumb);
                        }
                        if(file_exists($blogName)){
                            $zip->addFile("assets/files/blog/".$relativName, $blogName);
                        }
                        if(file_exists($blogNameThumb)){
                            $zip->addFile("assets/files/blog/thumbnail/".$relativName, $blogNameThumb);
                        }
                        if(file_exists($fileName)){
                            $zip->addFile("assets/files/file/".$relativName, $fileName);
                        }
                        if(file_exists($galleryName)){
                            $zip->addFile("assets/files/gallery/".$relativName, $galleryName);
                        }
                        if(file_exists($galleryNameThumb)){
                            $zip->addFile("assets/files/gallery/thumbnail/".$relativName, $galleryNameThumb);
                        }
                        if(file_exists($kegiatanName)){
                            $zip->addFile("assets/files/kegiatan/".$relativName, $kegiatanName);
                        }
                        if(file_exists($kegiatanNameThumb)){
                            $zip->addFile("assets/files/kegiatan/thumbnail/".$relativName, $kegiatanNameThumb);
                        }
                        if(file_exists($logoName)){
                            $zip->addFile("assets/files/logo/".$relativName, $logoName);
                        }
                        if(file_exists($logoNameThumb)){
                            $zip->addFile("assets/files/logo/thumbnail/".$relativName, $logoNameThumb);
                        }
                        if(file_exists($pageName)){
                            $zip->addFile("assets/files/pages/".$relativName, $pageName);
                        }
                        if(file_exists($pageNameThumb)){
                            $zip->addFile("assets/files/pages/thumbnail/".$relativName, $pageNameThumb);
                        }
                        if(file_exists($profileName)){
                            $zip->addFile("assets/files/profile/".$relativName, $profileName);
                        }
                        if(file_exists($profileNameThumb)){
                            $zip->addFile("assets/files/profile/thumbnail/".$relativName, $profileNameThumb);
                        }
                        if(file_exists($guruName)){
                            $zip->addFile("assets/files/sekolah/".$relativName, $guruName);
                        }
                        if(file_exists($guruNameThumb)){
                            $zip->addFile("assets/files/sekolah/thumbnail/".$relativName, $guruNameThumb);
                        }
                        if(file_exists($strukturName)){
                            $zip->addFile("assets/files/struktur/".$relativName, $strukturName);
                        }
                        if(file_exists($strukturNameThumb)){
                            $zip->addFile("assets/files/struktur/thumbnail/".$relativName, $strukturNameThumb);
                        }
                    }
                }
                $zip->close();

                if ($zip->open($zipFileName) === true) {
                    Storage::disk('SFTP')->putFileAs('.', $zipFileName, Helper::web_config('npsn').'.zip');
                    return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil membackup assets ke Server Dinas!', 'download' => url($zipFileName)]);
                } else {
                    return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => 'Gagal memproses backup karena masalah packing data!', 'download' => url($zipFileName)]);
                }
            }
        } catch(Throwable $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->getMessage()], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }
}
