<?php

namespace App\Http\Controllers\Api\v1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use App\User;

class UserController extends Controller
{
    public function login(Request $request)
    {
        $device_token = $request->device_token;
        $user = User::where(['username' => $request->username])->first();
        if ($user) {
            if (Hash::check($request->input('password'), $user->password)) {
                if ($user->api_token == NULL) {
                    $user->api_token = hash('sha256', Str::random(64));
                    $data = array('api_token' => $user->api_token, 'device_token' => $device_token);
                    User::where('username', $request->username)->update($data);
                    $data_user = $user;
                    return response()->json([
                        'data' => $data_user,
                        'message' => 'Success',
                    ], 200);
                } else {
                    return response()->json([
                        'message' => 'Another token exists',
                    ], 406);
                }
            } else {
                return response()->json([
                    'message' => 'Password not matched',
                ], 401);
            }
        } else {
            return response()->json([
                'message' => 'User not found',
            ], 404);
        }
    }

    public function cleartoken(Request $request)
    {
        $data = array('api_token' => NULL, 'device_token' => NULL);
        $update = User::where('api_token', $request->api_token)->update($data);
        if ($update) {
            return response()->json([
                'message' => 'OK',
            ], 200);
        } else {
            return response()->json([
                'message' => 'Bad request',
            ], 400);
        }
    }

    public function update_device_token(Request $request, $username)
    {
        $update = User::where('username', $username)->update(['device_token' => $request->device_token]);
        if ($update) {
            return response()->json([
                'message' => 'OK',
            ], 200);
        } else {
            return response()->json([
                'message' => 'Bad request',
            ], 400);
        }
    }

    public function update_password(Request $request, $username)
    {
        $oldpass = $request->password;
        $newpass = $request->new_password;
        $cek = User::where('username', $username)->first();
        if(Hash::check($oldpass, $cek->password))
        {
            User::where('username', $username)->update(['password' => Hash::make($newpass)]);
            return response()->json([
                'message' => 'OK',
            ], 200);
        }
        else
        {
            return response()->json([
                'message' => 'Failed',
            ], 400);
        }
    }
}
